\ProvidesClass{proc}

\LoadClass[a4paper,11pt,twoside]{article}

\RequirePackage{makeidx}
\RequirePackage{upgreek}
\RequirePackage{multirow}
\RequirePackage{multicol}
\RequirePackage[dvipsnames,svgnames,table]{xcolor}
\RequirePackage{graphicx}
\RequirePackage{epstopdf}
\RequirePackage{ulem}
\RequirePackage[colorlinks=true, linkcolor=blue, citecolor=blue, urlcolor=blue]{hyperref}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{times}
\RequirePackage[paperwidth=210mm,paperheight=297mm,top=22.2mm,right=20mm,bottom=15mm,left=20mm]{geometry}
\RequirePackage{enumitem}
  \setitemize{noitemsep,topsep=0pt,parsep=0pt,partopsep=6pt}
\RequirePackage{fancyhdr}
\RequirePackage{caption}
\RequirePackage{subcaption}
\RequirePackage{indentfirst}
\RequirePackage[pscoord]{eso-pic}% The zero point of the coordinate system is the lower left corner of the page (the default).

\makeatletter
	\newenvironment{indentation}[3]%
	{\par\setlength{\parindent}{#3}
	\setlength{\leftmargin}{#1}       \setlength{\rightmargin}{#2}%
	\advance\linewidth -\leftmargin       \advance\linewidth -\rightmargin%
	\advance\@totalleftmargin\leftmargin  \@setpar{{\@@par}}%
	\parshape 1\@totalleftmargin \linewidth\ignorespaces}{\par}%
\makeatother

% new LaTeX commands
\newcommand{\styleAbstract}[1]{\vspace{5mm} \par \noindent \begingroup \leftskip 0.7cm \rightskip\leftskip #1 \par \endgroup}
\newcommand{\styleAddress}[1]{\begin{center} \vspace{-9pt} \textit{#1} \end{center} }
\newcommand{\styleAuthor}[1]{\author{\Large{#1}} \date{} \maketitle \vspace{-20pt}}
\newcommand{\stylePaperTitle}[1]{\title{\vspace{-20pt} \textbf{#1}}}
\newcommand{\doi}[1]{\href{http://dx.doi.org/#1}{doi:~#1}}

% Alter some LaTeX defaults for better treatment of figures:
    \renewcommand{\topfraction}{0.9}	% max fraction of floats at top
    \renewcommand{\bottomfraction}{0.8}	% max fraction of floats at bottom
    \setcounter{topnumber}{2}
    \setcounter{bottomnumber}{2}
    \setcounter{totalnumber}{4}     % 2 may work better
    \renewcommand{\dbltopfraction}{0.9}	% fit big float above 2-col. text
    \renewcommand{\textfraction}{0.07}	% allow minimal text w. figs
    \renewcommand{\floatpagefraction}{0.7}	% require fuller float pages
	% N.B.: floatpagefraction MUST be less than topfraction !!
    \renewcommand{\dblfloatpagefraction}{0.7}	% require fuller float pages

% change Figure and Table caption
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Tab.}

%% header customization
\newcommand{\placetextbox}[3]{% \placetextbox{<horizontal pos>}{<vertical pos>}{<stuff>}
  \setbox0=\hbox{#3}% Put <stuff> in a box
  \AddToShipoutPictureFG*{% Add <stuff> to current page foreground
    \put(\LenToUnit{#1\paperwidth},\LenToUnit{#2\paperheight}){\vtop{{\null}#3}}%
  }%
}%

\fancyhf{}
\fancyheadoffset{10pt}
\setlength{\headheight}{20pt}
\fancyhead[RO]{\thepage}
\fancyhead[LE]{\thepage}
\cfoot{}
\pagestyle{fancy}

\makeatletter
% pagestyle for the first page: actualize default pagestyle by adding \headerdoi and \headerinfo
\fancypagestyle{firstpage}{
  \ps@fancy
  \fancyhead[RE]{\textcolor{white}{ }}
  \fancyhead[RO]{\textcolor{white}{ }}
  \fancyhead[LE]{\textcolor{white}{ }}
  \fancyhead[LO]{\textcolor{white}{ }}
  \def\headrulewidth{0pt}
}
\g@addto@macro{\maketitle}{\thispagestyle{firstpage}}
\makeatother

\newcounter{numrel}% Counter for numering relations
\newcounter{Hnumrel}% Keep hyperref happy and don't duplicate anchors
\renewcommand{\thenumrel}{\roman{numrel}}% Counter numrel uses lowercase roman numerals

\makeatletter
\newcommand{\numrel}[2]{% Relation numbering
  \refstepcounter{numrel}% Increment numrel counter and create correct reference hook
  \stepcounter{Hnumrel}%
  \ifmeasuring@\else\ltx@label{#2}\fi % Label numrel counter (issue only once)
  \overset{\text{(\thenumrel)}}{#1}% Print counter + relation
}
\makeatother